/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.client;

import com.google.gson.JsonSyntaxException;
import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.block.ModBlocks;
import dev.lucaargolo.charta.blockentity.ModBlockEntityTypes;
import dev.lucaargolo.charta.client.blockentity.BarShelfBlockEntityRenderer;
import dev.lucaargolo.charta.client.blockentity.CardTableBlockEntityRenderer;
import dev.lucaargolo.charta.client.entity.IronLeashKnotRenderer;
import dev.lucaargolo.charta.client.item.DeckItemExtensions;
import dev.lucaargolo.charta.compat.IrisCompat;
import dev.lucaargolo.charta.entity.ModEntityTypes;
import dev.lucaargolo.charta.game.crazyeights.CrazyEightsScreen;
import dev.lucaargolo.charta.game.fun.FunScreen;
import dev.lucaargolo.charta.game.solitaire.SolitaireScreen;
import dev.lucaargolo.charta.item.ModItems;
import dev.lucaargolo.charta.menu.ModMenus;
import dev.lucaargolo.charta.resources.MarkdownResource;
import dev.lucaargolo.charta.utils.CardImageUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.rendering.v1.BuiltinItemRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.CoreShaderRegistrationCallback;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_279;
import net.minecraft.class_284;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3929;
import net.minecraft.class_5616;
import net.minecraft.class_5912;
import net.minecraft.class_5944;
import net.minecraft.class_6344;
import net.minecraft.class_6367;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.Nullable;

public class ChartaClient
implements ClientModInitializer {
    public static final LinkedList<Triple<class_2561, Integer, class_2561>> LOCAL_HISTORY = new LinkedList();
    public static final HashMap<class_2960, byte[]> LOCAL_OPTIONS = new HashMap();
    private static final class_2960 BLUR_LOCATION = Charta.id("shaders/post/blur.json");
    private static class_276 glowRenderTarget;
    private static class_279 glowBlurEffect;
    public static class_5944 IMAGE_SHADER;
    public static class_5944 IMAGE_GLOW_SHADER;
    public static class_5944 IMAGE_ARGB_SHADER;
    public static class_5944 WHITE_IMAGE_SHADER;
    public static class_5944 WHITE_IMAGE_GLOW_SHADER;
    public static class_5944 WHITE_IMAGE_ARGB_SHADER;
    public static class_5944 CARD_SHADER;
    public static class_5944 CARD_GLOW_SHADER;
    public static class_5944 CARD_ARGB_SHADER;
    public static class_5944 PERSPECTIVE_SHADER;
    public static class_5944 GRAYSCALE_SHADER;
    private static final List<Consumer<Float>> cardFovUniforms;
    public static Consumer<Float> CARD_FOV;
    private static final List<Consumer<Float>> cardXRotUniforms;
    public static Consumer<Float> CARD_X_ROT;
    private static final List<Consumer<Float>> cardYRotUniforms;
    public static Consumer<Float> CARD_Y_ROT;
    private static final List<Consumer<Float>> cardInsetUniforms;
    public static Consumer<Float> CARD_INSET;
    public static class_5944 ENTITY_CARD_SHADER;
    public static class_5944 IRON_LEASH_SHADER;
    public static final MarkdownResource MARKDOWN;

    public void onInitializeClient() {
        BlockRenderLayerMap.INSTANCE.putBlocks(class_1921.method_23583(), new class_2248[]{ModBlocks.BERRY_WINE_GLASS, ModBlocks.CACTUS_WINE_GLASS, ModBlocks.EMPTY_WINE_GLASS});
        BlockRenderLayerMap.INSTANCE.putBlocks(class_1921.method_23583(), new class_2248[]{ModBlocks.SORGHUM_BEER_GLASS, ModBlocks.WHEAT_BEER_GLASS, ModBlocks.EMPTY_BEER_GLASS});
        ClientModEvents.onClientSetup(class_310.method_1551());
        ModelLoadingPlugin.register(ClientModEvents::registerCoverModel);
        ClientModEvents.registerClientExtensions();
        ClientModEvents.registerEntityRenderers();
        ClientModEvents.registerMenuScreens();
        ClientModEvents.addReloadListeners(ResourceManagerHelper.get((class_3264)class_3264.field_14188));
        CoreShaderRegistrationCallback.EVENT.register(ClientModEvents::registerShaders);
    }

    public static void generateImages() {
        class_310 client = class_310.method_1551();
        class_1060 manager = client.method_1531();
        manager.method_4616(Charta.MISSING_SUIT, (class_1044)CardImageUtils.convertImage(CardImageUtils.EMPTY_SUIT, IrisCompat.isPresent(), false));
        Charta.CARD_SUITS.getImages().forEach((id, image) -> {
            class_2960 suitId = ChartaClient.getSuitTexture(id);
            manager.method_4616(suitId, (class_1044)CardImageUtils.convertImage(image, IrisCompat.isPresent(), false));
        });
        manager.method_4616(Charta.MISSING_CARD, (class_1044)CardImageUtils.convertImage(CardImageUtils.EMPTY_CARD, IrisCompat.isPresent(), false));
        Charta.CARD_IMAGES.getImages().forEach((id, image) -> {
            class_2960 cardId = ChartaClient.getCardTexture(id);
            manager.method_4616(cardId, (class_1044)CardImageUtils.convertImage(image, IrisCompat.isPresent(), false));
        });
        Charta.DECK_IMAGES.getImages().forEach((id, image) -> {
            class_2960 deckId = ChartaClient.getDeckTexture(id);
            manager.method_4616(deckId, (class_1044)CardImageUtils.convertImage(image, IrisCompat.isPresent(), false));
        });
        IrisCompat.generateImages();
    }

    public static class_2960 getSuitTexture(class_2960 location) {
        if (Charta.CARD_SUITS.getImages().containsKey(location)) {
            return location.method_45138("suit/");
        }
        return Charta.MISSING_SUIT;
    }

    public static class_2960 getCardTexture(class_2960 location) {
        if (Charta.CARD_IMAGES.getImages().containsKey(location)) {
            return location.method_45138("card/");
        }
        return Charta.MISSING_CARD;
    }

    public static class_2960 getDeckTexture(class_2960 location) {
        if (Charta.DECK_IMAGES.getImages().containsKey(location)) {
            return location.method_45138("deck/");
        }
        return Charta.MISSING_CARD;
    }

    public static void clearImages() {
        class_310 client = class_310.method_1551();
        class_1060 manager = client.method_1531();
        manager.method_4615(Charta.MISSING_SUIT);
        Charta.CARD_SUITS.getImages().keySet().stream().map(ChartaClient::getSuitTexture).forEach(arg_0 -> ((class_1060)manager).method_4615(arg_0));
        Charta.CARD_SUITS.getImages().clear();
        manager.method_4615(Charta.MISSING_CARD);
        Charta.CARD_IMAGES.getImages().keySet().stream().map(ChartaClient::getCardTexture).forEach(arg_0 -> ((class_1060)manager).method_4615(arg_0));
        Charta.DECK_IMAGES.getImages().keySet().stream().map(ChartaClient::getDeckTexture).forEach(arg_0 -> ((class_1060)manager).method_4615(arg_0));
        IrisCompat.clearImages();
        Charta.CARD_IMAGES.getImages().clear();
        Charta.DECK_IMAGES.getImages().clear();
    }

    public static void processBlurEffect(float partialTick) {
        float f = 2.0f;
        if (glowBlurEffect != null) {
            glowBlurEffect.method_57799("Radius", f);
            glowBlurEffect.method_1258(partialTick);
        }
    }

    public static class_276 getGlowRenderTarget() {
        return glowRenderTarget;
    }

    public static class_279 getGlowBlurEffect() {
        return glowBlurEffect;
    }

    private static void loadGlowBlurEffect(class_5912 resourceProvider) {
        class_310 minecraft = class_310.method_1551();
        if (glowBlurEffect != null) {
            glowBlurEffect.close();
        }
        try {
            glowBlurEffect = new class_279(minecraft.method_1531(), resourceProvider, ChartaClient.getGlowRenderTarget(), BLUR_LOCATION);
            glowBlurEffect.method_1259(minecraft.method_22683().method_4489(), minecraft.method_22683().method_4506());
        }
        catch (IOException ioexception) {
            Charta.LOGGER.warn("Failed to load shader: {}", (Object)BLUR_LOCATION, (Object)ioexception);
        }
        catch (JsonSyntaxException jsonsyntaxexception) {
            Charta.LOGGER.warn("Failed to parse shader: {}", (Object)BLUR_LOCATION, (Object)jsonsyntaxexception);
        }
    }

    @Nullable
    public static class_5944 getImageShader() {
        return IMAGE_SHADER;
    }

    @Nullable
    public static class_5944 getImageGlowShader() {
        return IMAGE_GLOW_SHADER;
    }

    @Nullable
    public static class_5944 getImageArgbShader() {
        return IMAGE_ARGB_SHADER;
    }

    @Nullable
    public static class_5944 getWhiteImageShader() {
        return WHITE_IMAGE_SHADER;
    }

    @Nullable
    public static class_5944 getWhiteImageGlowShader() {
        return WHITE_IMAGE_GLOW_SHADER;
    }

    @Nullable
    public static class_5944 getWhiteImageArgbShader() {
        return WHITE_IMAGE_ARGB_SHADER;
    }

    @Nullable
    public static class_5944 getCardShader() {
        return CARD_SHADER;
    }

    @Nullable
    public static class_5944 getCardGlowShader() {
        return CARD_GLOW_SHADER;
    }

    @Nullable
    public static class_5944 getCardArgbShader() {
        return CARD_ARGB_SHADER;
    }

    @Nullable
    public static class_5944 getPerspectiveShader() {
        return PERSPECTIVE_SHADER;
    }

    @Nullable
    public static class_5944 getGrayscaleShader() {
        return GRAYSCALE_SHADER;
    }

    static {
        cardFovUniforms = new ArrayList<Consumer<Float>>();
        CARD_FOV = f -> cardFovUniforms.forEach(c -> c.accept(f));
        cardXRotUniforms = new ArrayList<Consumer<Float>>();
        CARD_X_ROT = f -> cardXRotUniforms.forEach(c -> c.accept(f));
        cardYRotUniforms = new ArrayList<Consumer<Float>>();
        CARD_Y_ROT = f -> cardYRotUniforms.forEach(c -> c.accept(f));
        cardInsetUniforms = new ArrayList<Consumer<Float>>();
        CARD_INSET = f -> cardInsetUniforms.forEach(c -> c.accept(f));
        MARKDOWN = new MarkdownResource();
    }

    public static class ClientModEvents {
        public static void onClientSetup(class_310 minecraft) {
            minecraft.method_20493(() -> {
                glowRenderTarget = new class_6367(minecraft.method_22683().method_4489(), minecraft.method_22683().method_4506(), false, class_310.field_1703);
                glowRenderTarget.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
                glowRenderTarget.method_1230(class_310.field_1703);
            });
        }

        public static void registerCoverModel(ModelLoadingPlugin.Context context) {
            context.addModels(new class_2960[]{Charta.id("deck")});
        }

        public static void registerClientExtensions() {
            BuiltinItemRendererRegistry.INSTANCE.register((class_1935)ModItems.DECK, (BuiltinItemRendererRegistry.DynamicItemRenderer)new DeckItemExtensions());
        }

        public static void registerEntityRenderers() {
            EntityRendererRegistry.register(ModEntityTypes.SEAT, class_6344::new);
            EntityRendererRegistry.register(ModEntityTypes.IRON_LEASH_KNOT, IronLeashKnotRenderer::new);
            class_5616.method_32144(ModBlockEntityTypes.CARD_TABLE, CardTableBlockEntityRenderer::new);
            class_5616.method_32144(ModBlockEntityTypes.BAR_SHELF, BarShelfBlockEntityRenderer::new);
        }

        public static void addReloadListeners(ResourceManagerHelper event) {
            event.registerReloadListener((IdentifiableResourceReloadListener)MARKDOWN);
        }

        public static void registerMenuScreens() {
            class_3929.method_17542(ModMenus.CRAZY_EIGHTS, CrazyEightsScreen::new);
            class_3929.method_17542(ModMenus.FUN, FunScreen::new);
            class_3929.method_17542(ModMenus.SOLITAIRE, SolitaireScreen::new);
        }

        public static void registerShaders(CoreShaderRegistrationCallback.RegistrationContext context) throws IOException {
            class_3300 manager = class_310.method_1551().method_1478();
            ChartaClient.loadGlowBlurEffect((class_5912)manager);
            cardFovUniforms.clear();
            cardXRotUniforms.clear();
            cardYRotUniforms.clear();
            cardInsetUniforms.clear();
            context.register(Charta.id("image"), class_290.field_1575, instance -> {
                IMAGE_SHADER = instance;
            });
            context.register(Charta.id("image_glow"), class_290.field_1575, instance -> {
                IMAGE_GLOW_SHADER = instance;
            });
            context.register(Charta.id("image_argb"), class_290.field_1575, instance -> {
                IMAGE_ARGB_SHADER = instance;
            });
            context.register(Charta.id("white_image"), class_290.field_1575, instance -> {
                WHITE_IMAGE_SHADER = instance;
            });
            context.register(Charta.id("white_image_glow"), class_290.field_1575, instance -> {
                WHITE_IMAGE_GLOW_SHADER = instance;
            });
            context.register(Charta.id("white_image_argb"), class_290.field_1575, instance -> {
                WHITE_IMAGE_ARGB_SHADER = instance;
            });
            context.register(Charta.id("card"), class_290.field_1575, instance -> {
                cardFovUniforms.add(arg_0 -> ((class_284)Objects.requireNonNull(instance.method_34582("Fov"))).method_1251(arg_0));
                cardXRotUniforms.add(arg_0 -> ((class_284)Objects.requireNonNull(instance.method_34582("XRot"))).method_1251(arg_0));
                cardYRotUniforms.add(arg_0 -> ((class_284)Objects.requireNonNull(instance.method_34582("YRot"))).method_1251(arg_0));
                cardInsetUniforms.add(arg_0 -> ((class_284)Objects.requireNonNull(instance.method_34582("InSet"))).method_1251(arg_0));
                CARD_SHADER = instance;
            });
            context.register(Charta.id("card_glow"), class_290.field_1575, instance -> {
                cardFovUniforms.add(arg_0 -> ((class_284)Objects.requireNonNull(instance.method_34582("Fov"))).method_1251(arg_0));
                cardXRotUniforms.add(arg_0 -> ((class_284)Objects.requireNonNull(instance.method_34582("XRot"))).method_1251(arg_0));
                cardYRotUniforms.add(arg_0 -> ((class_284)Objects.requireNonNull(instance.method_34582("YRot"))).method_1251(arg_0));
                cardInsetUniforms.add(arg_0 -> ((class_284)Objects.requireNonNull(instance.method_34582("InSet"))).method_1251(arg_0));
                CARD_GLOW_SHADER = instance;
            });
            context.register(Charta.id("card_argb"), class_290.field_1575, instance -> {
                cardFovUniforms.add(arg_0 -> ((class_284)Objects.requireNonNull(instance.method_34582("Fov"))).method_1251(arg_0));
                cardXRotUniforms.add(arg_0 -> ((class_284)Objects.requireNonNull(instance.method_34582("XRot"))).method_1251(arg_0));
                cardYRotUniforms.add(arg_0 -> ((class_284)Objects.requireNonNull(instance.method_34582("YRot"))).method_1251(arg_0));
                cardInsetUniforms.add(arg_0 -> ((class_284)Objects.requireNonNull(instance.method_34582("InSet"))).method_1251(arg_0));
                CARD_ARGB_SHADER = instance;
            });
            context.register(Charta.id("perspective"), class_290.field_1575, instance -> {
                cardFovUniforms.add(arg_0 -> ((class_284)Objects.requireNonNull(instance.method_34582("Fov"))).method_1251(arg_0));
                cardXRotUniforms.add(arg_0 -> ((class_284)Objects.requireNonNull(instance.method_34582("XRot"))).method_1251(arg_0));
                cardYRotUniforms.add(arg_0 -> ((class_284)Objects.requireNonNull(instance.method_34582("YRot"))).method_1251(arg_0));
                cardInsetUniforms.add(arg_0 -> ((class_284)Objects.requireNonNull(instance.method_34582("InSet"))).method_1251(arg_0));
                PERSPECTIVE_SHADER = instance;
            });
            context.register(Charta.id("grayscale"), class_290.field_1575, instance -> {
                GRAYSCALE_SHADER = instance;
            });
            context.register(Charta.id("rendertype_entity_card"), class_290.field_1580, instance -> {
                ENTITY_CARD_SHADER = instance;
            });
            context.register(Charta.id("rendertype_iron_leash"), class_290.field_21468, instance -> {
                IRON_LEASH_SHADER = instance;
            });
        }
    }
}

